---
Note type: Reference
tags:
  - "#REFERENCE"
Reference type: Book
Bib_ref: "Dryzek JS (2013) _The Politics of the Earth: Environmental Discourses_. Oxford University Press."
Title: "The Politics of the Earth: Environmental Discourses"
Authors: John S. Dryzek
Year: 2013
Journal-publisher: 
Read: Read
Related areas:
  - "[[Research]]"
  - "[[Teaching]]"
Related projects:
  - "[[Paper Y]]"
  - "[[SOC301 Social Research Methods Course]]"
Related tasks: 
Related references: 
Related zettels:
  - "[[discourse analysis]]"
  - "[[metaphor]]"
  - "[[discourse]]"
  - "[[Sustainability]]"
  - "[[complexity]]"
  - "[[rhetoric]]"
  - "[[environmental discourses]]"
  - "[[sustainable development]]"
  - "[[critical discourse analysis]]"
Related meeting notes: 
Related resources: 
Related people: 
aliases: 
Creation date: 2024-05-27
Last modified: 2024-05-27
---

## Overview

### Context

### RQ

### Thesis

### Methodology

### Theoretical approach

### Findings

### Contributions

### Striking points

### Further research suggested

### My ideas/responses

### Useful references

## Fleeting notes

## Summary

## Overview

### Context

### RQ

### Thesis

### Methodology

### Theoretical approach

### Findings

### Contributions

### Striking points

### Further research suggested

### My ideas/responses

### Useful references

## Fleeting notes

## Summary

## Overview

### Context

### Aim

“This inquiry rests on the contention that language matters, that the way we construct, interpret, discuss, and analyze environmental problems has all kinds of consequences. My intent is to lay out the basic structure of the discourses that have dominated recent environmental politics, and present their history, conflicts, and transformations.” ([[Dryzek 2013]], p. 30)

“To assess more fully the worth and impact of a discourse requires attention to its critics as well as its adherents. Sometimes, adherents of different discourses will ignore and dismiss rather than engage one another. Nevertheless, dispute does occur across the boundaries of different discourses. Frequently, this occurs between the environmental discourse in question and the older discourse of industrialism. Occasionally, debate is engaged between the problem-solving, limits, sustainability, and green radical discourses. **One goal of this book is to promote such interchange**.” ([[Dryzek 2013]], p. 40)

### RQ

### Thesis

### Methodology

### Theoretical approach

### Findings

### Contributions

### Striking points

### Further research suggested

### My ideas/responses

### Useful references

## Summary

### History of environmental concerns

- “The early concerns were with pollution, wilderness preservation, population growth, and depletion of natural resources.” ([[Dryzek 2013]], p. 22)
- “Over time, these concerns have been joined by worries about energy supply, biodiversity, species extinction, climate change and other disruptions of the Earth system, depletion of the ozone layer in the upper atmosphere, toxic wastes, the protection of whole ecosystems, environmental justice, food safety, and genetically modified organisms.” ([[Dryzek 2013]], p. 22)
- “In all these conflicts, the different sides interpret the issues at hand in very different ways, At any time, the way the issue is dealt with depends largely (though not completely) on the balance of competing discourses. In this book I intend making sense of the last fifty years or so of environmental concern by mapping these discourses.” ([[Dryzek 2013]], p. 27)
    - “Even if one believes in progress (as I do), it would be a mistake to think of the history of environmental affairs in these terms.” ([[Dryzek 2013]], p. 25)
    - “contests over meaning are ubiquitous, and the way we think about basic concepts concerning the environment can change dramatically over time” ([[Dryzek 2013]], p. 25)

### The [[complexity]] of environmental problems

- “ [[complexity]] refers to the number and variety of elements and interactions in the environment of a decision system.” ([[Dryzek 2013]], p. 28)
- “When human decision systems (be they individuals or collective bodies such as governments) confront environmental problems, they encounter two orders of complexity.” ([[Dryzek 2013]], p. 28)
	 - “Ecosystems are complex, and our knowledge of them is limited,” ([[Dryzek 2013]], p. 28)
	 - “Human social systems are complex too, which is why there is so much work for the ever-growing number of social scientists who study them.” ([[Dryzek 2013]], p. 28)
	 - “Environmental problems by definition are found at the intersection of ecosystems and human social systems, thus doubly complex.” ([[Dryzek 2013]], p. 28)
- “The more complex a situation, the larger the number of plausible perspectives upon it - because the harder it is to prove any one of them wrong.” ([[Dryzek 2013]], p. 28)

### [[discourse]] as a means of [[sensemaking]] in the context of [[complexity]]

- “A [[discourse]] is a shared way of apprehending the world.” ([[Dryzek 2013]], p. 28)
- “Embedded in language, it enables those who subscribe to it to interpret bits of information and put them together into coherent stories or accounts. Discourses construct meanings and relationships, helping define common sense and legitimate knowledge. Each discourse rests on assumptions, judgments, and contentions that provide the basic terms for analysis, debates, agreements, and disagreements.” ([[Dryzek 2013]], p. 28)
- “discourses both enable and constrain communication.” ([[Dryzek 2013]], p. 29) - [[enabling constraints]]
- “Discourses are bound up with political practices and [[power]]" ([[Dryzek 2013]], p. 29)
	- "Discourses can themselves embody power in the way they condition the perceptions and values of those subject to them, such that some interests are advanced, others suppressed, some people made more compliant and governable (Foucault, 1980).”
	- “Discourses are also intertwined with some material political realities” - e.g. neoliberal borderlessness of capital

### Classifying the main [[environmental discourses]]

#### Environmental problem solving

- **Reformist** and **prosaic**: “defined by taking the political-economic status quo as given but in need of adjustment to cope with environmental problems, especially via public policy.” ([[Dryzek 2013]], p. 34)
- Story: particular economic activities have unpleasant side-effects, which require piecemeal remedies.
- e.g. “administrative regulation” - command and control
    or
- “market-type incentive mechanisms” - carbon markets, private governance
- “Within the overall discourse of environmental problem solving there may be substantial disagreement as to which of these forms is appropriate. So, for example, a debate between proponents of administrative regulation and market-type incentive mechanisms for pollution control has been under way since the 1970s, with market proponents gradually gaining ground.”

#### Limits and survival

- “unchecked economic expansion and population growth will eventually exceed the Earth's stock of natural resources and the capacity of its ecosystems to support human agricultural and industrial activity, or the ability of the Earth system to accommodate stress.” ([[Dryzek 2013]], p. 34)
- Story: “the need to curb ever-growing human demands on the life-support capacities of natural systems.”
- e.g. doughnut economics, planetary boundaries
- **“radical** because it seeks a wholesale redistribution of power within the industrial political economy, and a wholesale reorientation away from perpetual economic growth” ([[Dryzek 2013]], p. 35)
- **“prosaic** because it sees solutions in terms of the options set by industrialism, notably, greater control of existing systems by administrators, scientists and other responsible elites.” ([[Dryzek 2013]], p. 35)

#### Sustainability

- Defined by ideas of ecological modernization whereby economic growth and environmental protection are seen as essentially complementary
- “defined by **imaginative** attempts to dissolve the conflicts between environmentalism and economic values that energize the discourses of **problem solving** and **limits**” ([[Dryzek 2013]], p. 35)
- **Reformist** because it remains commited to industrialist socioeconomics in this pursuit of a win-win solution
- Has become a “nodal discourse” (Fairclough, 2006) “around which other discourses cluster” ([[Dryzek 2013]], p. 35)

#### Green radicalism

- “adherents reject the basic structure of industrial society and the way the environment is conceptualized therein {**radical**} in favor of a variety of quite different alternative interpretations of humans, their society, and their place in the world {**imaginitive**}.” ([[Dryzek 2013]], p. 35)

### The elements of discourse

- **[[Ontology]]** - “Basic entities recognized or constructed”
    - “Different discourses see different things in the world.” - _connect to [[sensemaking]], simplifying the complexity of the world_
    - e.g. “Some discourses recognize the existence of ecosystems, others have no concept of natural systems at all, seeing nature only in terms of brute matter.” ([[Dryzek 2013]], p. 36)
- “Assumptions about natural **relationships**” ([[Dryzek 2013]], p. 37)
    - “All discourses embody notions of what is natural in the relationships between different entities”
    - e.g. competition vs. cooperation; hierarchies vs equalities
- “**Agents** and their motives” ([[Dryzek 2013]], p. 37)
    - e.g. human vs non-human actors
    - e.g. “enlightened elites, rational consumers, ignorant and shortsighted populations, virtuous ordinary citizens, a Gaia that may be tough and forgiving or fragile and punishing […].” ([[Dryzek 2013]], p. 37)
- “Key **[[metaphor|metaphors]]** and other rhetorical devices” ([[Dryzek 2013]], p. 37)
    - “Metaphors are rhetorical devices, deployed to convince listeners or readers by putting a situation in a particular light.” ([[Dryzek 2013]], p. 38)
    - e.g. spaceship earth, tragedy of the commons, machines, organisms, war, goddess, intelligence
